/**
  Copyright (c) 2010 Freescale Semiconductor
  
  \file       AnimationCtrl.c
  \brief      This file code controlls the active animations
  \author     Freescale Semiconductor
  \author     Automotive Systems Solutions Engineering
  \author     IM, b06623
  \version	  2.0
  \revision	  $Revision: 45 $
  \date  	  $Date: 2010-10-04 12:17:38 -0500 (Mon, 04 Oct 2010) $  
  
* History:  26/January/2009- Initial Version
			25/May/2010	- Context Switching support

* MISRA VIOLATIONS:
	- [ MISRA 13.6 ]

* Copyright (c) 2010, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/
 
 
#include "AnimationCtrl.h"
#include "DMAHandler.h"
#include "FLIB.h"

uint8_t MCManager_Ctx = 0;
uint8_t MCManager_maxMC = MCMANAGER_MAXCLIPSCTX0;
uint8_t MCManager_maxLayers = DCU_MAXLAYERS;

#ifdef DCULITE
#define MCMANAGER_CTXNO	2
#else
#define MCMANAGER_CTXNO	1
#endif

/* Keeps track of registered movie clips */
mc_properties_t* MCManager_MClips_1[MCMANAGER_MAXCLIPSCTX0];
#ifdef DCULITE
mc_properties_t* MCManager_MClips_2[MCMANAGER_MAXCLIPSCTX1];
#endif
mc_properties_t** MCManager_MClips = MCManager_MClips_1;

/* Vars to reference the movie clip owner of certain layer */
uint16_t MCManager_LayerOwner_1[DCU_MAXLAYERS];
#ifdef DCULITE
uint16_t MCManager_LayerOwner_2[DCU_DCULITEMAXLAYERS];
#endif
uint16_t* MCManager_LayerOwner = MCManager_LayerOwner_1;	

/* Determines if performing Defragmentation after killing one movie clip */
uint8_t MCManager_AutoRefreshFlag[MCMANAGER_CTXNO];


void MCManager_SetContext(uint8_t ctx)
{
	if(ctx == 0)
	{
	MCManager_Ctx = 0;
    	MCManager_maxMC = MCMANAGER_MAXCLIPSCTX0;
    	MCManager_maxLayers = DCU_MAXLAYERS;
    	MCManager_MClips = MCManager_MClips_1;	
    	MCManager_LayerOwner = MCManager_LayerOwner_1;		
	}
#ifdef DCULITE	
	else
	{
	MCManager_Ctx = 1;
    	MCManager_maxMC = MCMANAGER_MAXCLIPSCTX1;
    	MCManager_maxLayers = DCU_DCULITEMAXLAYERS;
    	MCManager_MClips = MCManager_MClips_2;		
    	MCManager_LayerOwner = MCManager_LayerOwner_2;	
	}
#endif	
}

void MCManager_Init(void)
{
    uint32_t i; 
    MCManager_maxMC = MCMANAGER_MAXCLIPSCTX0;
    MCManager_maxLayers = DCU_MAXLAYERS;
    MCManager_Ctx = 0;
    MCManager_MClips = MCManager_MClips_1;
    MCManager_LayerOwner = MCManager_LayerOwner_1;
    
    
    for(i = 0u; i < MCManager_maxMC ;i++)
    {
		MCManager_MClips[i] = NULL_PTR;
    }     

    for(i = 0u; i < MCManager_maxLayers ;i++)
    {
		MCManager_LayerOwner[i] = MCMANAGER_NOOWNER;
    } 	
    
    MCManager_AutoRefreshFlag[MCManager_Ctx] = 0;
}

/* This clip contains all the clips for the animation */
/* It must be called each time a frame should change */
void MCManager_Main(uint32_t CurrentFrame)
{
    uint32_t i;
    uint32_t j;
    uint32_t k;
    uint32_t Mask;
    uint32_t MarkedLayers;

    for(i = 0u; i < MCManager_maxMC; i++)
    {
	if(MCManager_MClips[i] != NULL_PTR)
	{
	    if(MCManager_MClips[i]->enabled == 1u)
	    {
			if(MCManager_MClips[i]->kill == 1u)
			{
			    /* Disable Layers (HW and Flags) */
			    Mask = 1u;
			    for(j = 0u; j < MCManager_maxLayers; j++)
			    {
					if(Mask&((uint32_t)MCManager_MClips[i]->usedLayers))
					{
					    MCManager_LayerOwner[j] = MCMANAGER_NOOWNER;
					    DCU_LayerDisable( j );
					    FLIB_AnimCancel(j); //to do: unbind FLIB from this driver
					}
					Mask = Mask<<1u;
			    }
			    MCManager_MClips[i]->enabled = 0u;		    
			    MCManager_MClips[i]->kill = 0u;
			    MCManager_MClips[i]->run = 0u;
			    if(MCManager_MClips[i]->autoDispose == 1)
			    {
			    	if(MCManager_MClips[i]->Dispose !=  NULL_PTR)
		    		{
		    			MCManager_MClips[i]->Dispose();	
		    		}
			    }
			    if(MCManager_AutoRefreshFlag[MCManager_Ctx] == 1)
			    {
			    	DMAHR_ScheduleDefrag(MCManager_Refresh);	
			    }
			    
			}
			else
			{
				MCManager_MClips[i]->run = 0u;
			    MCManager_MClips[i]->mcFunction(CurrentFrame);
			}
	    }
	    else if(MCManager_MClips[i]->run == 1u)
	    {
	    /* If running, no killing allowed at the same time */
	    MCManager_MClips[i]->kill = 0u;
		/* Check layers and priority */
		Mask = 1u;
		MarkedLayers = 0u;
		for(j = 0u; j < MCManager_maxLayers; j++)
		{

		    if(Mask&((uint32_t)MCManager_MClips[i]->usedLayers))
		    {
			/* THIS layer is allocated */
			if(MCManager_LayerOwner[j] != MCMANAGER_NOOWNER)
			{
			    if(MCManager_MClips[i]->priority > MCManager_MClips[MCManager_LayerOwner[j]]->priority)
			    {
				MarkedLayers = MarkedLayers | Mask;  
			    }
			    else
			    {
				/* Failed to run the current clip */
                /* VIOLATION TO [ MISRA 13.6 ] Rationale: We break after modifying the value of j. It does not affects*/   
				j = 0u;
				break;
			    }
			}
			else
			{
			    MarkedLayers = MarkedLayers | Mask;
			}
		    }
		    Mask = Mask<<1u;
		}
		if(j == MCManager_maxLayers)
		{
		    /* Priority of THIS is higher than other running clips */
		    /* Allocate Layers and Kill current overlapping movie clips */
		    for(j = 0u; j < MCManager_maxLayers; j++)
		    {
			/* Check Marked Layers invading higher priority MC */
			if(MarkedLayers&1u)
			{
			    /* For this marked layer, kill the owning movie clip */
			    /* Could be already de-activated (even if marked)*/
			    if(MCManager_LayerOwner[j] != MCMANAGER_NOOWNER)
			    {
				/* Kill the MC and all the owned layers */
				MCManager_MClips[MCManager_LayerOwner[j]]->enabled = 0u;
				MCManager_MClips[MCManager_LayerOwner[j]]->kill = 0u;
				Mask = 1u;
				for(k = 0u; k < MCManager_maxLayers; k++)
				{
				    if(Mask&((uint32_t)MCManager_MClips[MCManager_LayerOwner[j]]->usedLayers))
				    {
					MCManager_LayerOwner[k] = MCMANAGER_NOOWNER;
					DCU_LayerDisable( k );
				    }
				    Mask = Mask<<1u;
				}			    
			    }

			    MCManager_LayerOwner[j] = (uint16_t)i;			
			}
			MarkedLayers = MarkedLayers>>1u;
		    }
		    MCManager_MClips[i]->frameLatch = 0u;
		    MCManager_MClips[i]->enabled = 1u;
		    MCManager_MClips[i]->run = 0u;
		    MCManager_MClips[i]->mcFunction(CurrentFrame);
		} /* if(j == MCManager_maxLayers) */	       
	    } /* else if(MCManager_MClips[i]->run == 1u) */
        else
        {
        } 
	} /* if(MCManager_MClips[i] != NULL_PTR) */
    }/* for(i = 0u; i < MCMANAGER_MAXCLIPSCTX; i++) */
}

void MCManager_Refresh(void)
{
	uint32_t i;
    	
	for(i = 0u; i < MCManager_maxMC; i++)
    {
		if(MCManager_MClips[i] != NULL_PTR)
		{
			if(MCManager_MClips[i]->enabled == 1u)
	    	{
	    		if(MCManager_MClips[i]->Refresh !=  NULL_PTR)
	    		{
	    			MCManager_MClips[i]->Refresh();	
	    		}
	    	}
		}
    }
}

void MCManager_AutoRefresh(void)
{
	MCManager_AutoRefreshFlag[MCManager_Ctx] = 1;
}
